require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("menu_background", "data/images/lvl_menu/menu_background.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("logo", "data/images/lvl_menu/logo.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("character", "data/images/lvl_menu/menu_character.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("newgame", "data/images/lvl_menu/menu_newgame.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("newgame_act", "data/images/lvl_menu/menu_newgame_act.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("options", "data/images/lvl_menu/menu_options.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("options_act", "data/images/lvl_menu/menu_options_act.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("credits", "data/images/lvl_menu/menu_credits.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("credits_act", "data/images/lvl_menu/menu_credits_act.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("exit", "data/images/lvl_menu/menu_exit.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("exit_act", "data/images/lvl_menu/menu_exit_act.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 1
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 2

-- Background starts
local scale = 0.4
lua:create_sprite("background", ST_SCROLLING,"menu_background",      0.0, 46.0) 
lua:sprite_shape("background",ST_SCROLLING,                          scale * 2048.0, scale * 1024.0)
lua:textured_sprite_tex_coords("background", ST_SCROLLING,           0.0, 0.0, 1.0, 1.0)
lua:scrolling_sprite("background", 									 SS_HORIZONTAL, 0.005)
g_level.upload("background",                                         0)

-- Background ends

-- Logo starts
lua:create_sprite("logo", ST_TEXTURED,"logo",                  0.0, 128.0) 
lua:sprite_shape("logo",ST_TEXTURED,                           1.5*256.0, 1.5*128.0)
lua:textured_sprite_tex_coords("logo", ST_TEXTURED,            0.0, 0.0, 1.0, 1.0)
g_level.upload("logo",                                         1)
-- Logo Ends

-- Character starts
local scale = 0.5
lua:create_sprite("character", ST_TEXTURED,"character",             140.0, -120.0) 
lua:sprite_shape("character",ST_TEXTURED,                           scale * 512.0, scale * 512.0)
lua:textured_sprite_tex_coords("character", ST_TEXTURED,            0.0, 0.0, 1.0, 1.0)
g_level.upload("character",                                         1)
-- Character ends

--Create Buttons
local scale = 0.70
local x_all = 0.0
local y_all = -128.0
lua:create_sprite("newgame", ST_TEXTURED,"newgame",                 -145.0 + x_all, 235.0 + y_all) 
lua:sprite_shape("newgame",ST_TEXTURED,                             scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("newgame", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

lua:create_sprite("newgame_act", ST_TEXTURED,"newgame_act",         -145.0 + x_all, 235.0 + y_all) 
lua:sprite_shape("newgame_act",ST_TEXTURED,                         scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("newgame_act", ST_TEXTURED,          0.0, 0.0, 1.0, 1.0)

lua:create_sprite("options", ST_TEXTURED,"options",                 -105.0 + x_all, 165.0 + y_all) 
lua:sprite_shape("options",ST_TEXTURED,                             scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("options", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

lua:create_sprite("options_act", ST_TEXTURED,"options_act",         -105.0 + x_all, 165.0 + y_all) 
lua:sprite_shape("options_act",ST_TEXTURED,                         scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("options_act", ST_TEXTURED,          0.0, 0.0, 1.0, 1.0)

lua:create_sprite("credits", ST_TEXTURED,"credits",                 -95.0 + x_all, 95.0 + y_all) 
lua:sprite_shape("credits",ST_TEXTURED,                             scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("credits", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

lua:create_sprite("credits_act", ST_TEXTURED,"credits_act",         -95.0 + x_all, 95.0 + y_all) 
lua:sprite_shape("credits_act",ST_TEXTURED,                         scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("credits_act", ST_TEXTURED,          0.0, 0.0, 1.0, 1.0)

lua:create_sprite("exit", ST_TEXTURED,"exit",                       0.0 + x_all, 25.0 + y_all) 
lua:sprite_shape("exit",ST_TEXTURED,                                scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("exit", ST_TEXTURED,                 0.0, 0.0, 1.0, 1.0)

lua:create_sprite("exit_act", ST_TEXTURED,"exit_act",               0.0 + x_all, 25.0 + y_all) 
lua:sprite_shape("exit_act",ST_TEXTURED,                            scale * 256.0, scale * 256.0)
lua:textured_sprite_tex_coords("exit_act", ST_TEXTURED,             0.0, 0.0, 1.0, 1.0)


lua:create_button("newgame_button","newgame","newgame_act", "","","data/scripts/srt_menu_fade_out_1.lua")  -- name: the button name. texture_idle: the texture shown when idle. texture_highlight: the texture shown when focus.  press_sound. change_sound.  script: the scipt file to be done when pressing the button
lua:create_button("options_button","options","options_act", "","","data/scripts/srt_menu_fade_out_3.lua")
lua:create_button("credits_button","credits","credits_act", "","","data/scripts/srt_menu_fade_out_2.lua")
lua:create_button("exit_button","exit","exit_act", "","","data/scripts/srt_exit_game.lua")

lua:button_dependencies("newgame_button","","options_button","","")  --name: button name. button_up. button_down. button_left. button_right.
lua:button_dependencies("options_button","newgame_button","credits_button","","")
lua:button_dependencies("credits_button","options_button","exit_button","","")
lua:button_dependencies("exit_button","credits_button","","","")

lua:set_focused_button("newgame_button")  -- must be done before upload...

g_level.upload("newgame_button",2) 
g_level.upload("options_button",2) 
g_level.upload("credits_button",2) 
g_level.upload("exit_button",2) 


lua:set_game_state(GS_MENU) -- sets the game state to menu. thus you are able to use the menu commands

fade_in(3)
